<?php
/**
 * Theme functions and definitions.
 *
 * For additional information on potential customization options,
 * read the developers' documentation:
 *
 * https://developers.elementor.com/docs/hello-elementor-theme/
 *
 * @package HelloElementorChild
 */

if ( ! defined( 'ABSPATH' ) ) {
	exit; // Exit if accessed directly.
}

define( 'HELLO_ELEMENTOR_CHILD_VERSION', '2.0.0' );

/**
 * Load child theme scripts & styles.
 *
 * @return void
 */
function hello_elementor_child_scripts_styles() {

	wp_enqueue_style(
		'hello-elementor-child-style',
		get_stylesheet_directory_uri() . '/style.css',
		[
			'hello-elementor-theme-style',
		],
		HELLO_ELEMENTOR_CHILD_VERSION
	);

}
add_action( 'wp_enqueue_scripts', 'hello_elementor_child_scripts_styles', 20 );

function tanme_enqueue_fonts() {
    wp_enqueue_style(
        'poppins-font',
        'https://fonts.googleapis.com/css2?family=Poppins:wght@300;400;500;600;700&display=swap',
        array(),
        null
    );
}
add_action('wp_enqueue_scripts', 'tanme_enqueue_fonts');

add_action('init', function() {
    add_rewrite_rule(
        '^beli/([^/]*)/?',
        'index.php?wc_add_slug=$matches[1]',
        'top'
    );
    add_rewrite_tag('%wc_add_slug%', '([^&]+)');
});

add_action('template_redirect', function(){
    $slug = get_query_var('wc_add_slug');

    if(!$slug) return;

    $product = get_page_by_path($slug, OBJECT, 'product');

    if(!$product) return;

    WC()->cart->add_to_cart($product->ID);

    wp_safe_redirect(wc_get_cart_url());
    exit;
});

add_filter( 'woocommerce_product_add_to_cart_url', function( $url, $product ){
    return home_url( 'add-to-cart/' . $product->get_slug() );
}, 10, 2 );
